
#include <string.h>
#include <stdlib.h>
#include <assert.h>

#include "../Ninereeds Broadcast Lib/Ninereeds Broadcast Lib.h"

#pragma optimize ("a", on)

CMachineParameter const gp_Chan  = {pt_byte, "Channel", "Channel", 0x01, 0xFF, 0x00, MPF_STATE, 0x01};
CMachineParameter const gp_Time  = {pt_word, "Time",    "Time",    0x0000, 0xFFFE, 0xFFFF, MPF_STATE, 0x0000};

CMachineParameter const gp_Cmd   = {pt_byte, "Command", "Command", 0x01, 0xff, 0x00, MPF_STATE, 0x00};

CMachineParameter const gp_Byte1 = {pt_byte, "Byte 1", "Byte Param 1", 0x00, 0xfe, 0xff, MPF_STATE, 0x00};
CMachineParameter const gp_Byte2 = {pt_byte, "Byte 2", "Byte Param 2", 0x00, 0xfe, 0xff, MPF_STATE, 0x00};
CMachineParameter const gp_Byte3 = {pt_byte, "Byte 3", "Byte Param 3", 0x00, 0xfe, 0xff, MPF_STATE, 0x00};
CMachineParameter const gp_Byte4 = {pt_byte, "Byte 4", "Byte Param 4", 0x00, 0xfe, 0xff, MPF_STATE, 0x00};

CMachineParameter const gp_Word1 = {pt_word, "Word 1", "Word Param 1", 0x0000, 0xfffe, 0xffff, MPF_STATE, 0x0000};
CMachineParameter const gp_Word2 = {pt_word, "Word 2", "Word Param 2", 0x0000, 0xfffe, 0xffff, MPF_STATE, 0x0000};
CMachineParameter const gp_Word3 = {pt_word, "Word 3", "Word Param 3", 0x0000, 0xfffe, 0xffff, MPF_STATE, 0x0000};
CMachineParameter const gp_Word4 = {pt_word, "Word 4", "Word Param 4", 0x0000, 0xfffe, 0xffff, MPF_STATE, 0x0000};

#pragma pack(1)

struct gvals
{
	byte p_Channel;
  word p_Time;
	byte p_Command;

	byte p_Byte_Param1;
	byte p_Byte_Param2;
	byte p_Byte_Param3;
	byte p_Byte_Param4;

	word p_Word_Param1;
	word p_Word_Param2;
	word p_Word_Param3;
	word p_Word_Param4;
};

#pragma pack()

CMachineParameter const *pParameters[] =
{
	// global
	&gp_Chan,  &gp_Time,  &gp_Cmd,
	&gp_Byte1, &gp_Byte2, &gp_Byte3, &gp_Byte4,
	&gp_Word1, &gp_Word2, &gp_Word3, &gp_Word4
	// track
};

CMachineInfo const MacInfo =
{
	MT_GENERATOR, MI_VERSION, 0,				// type, version, flags
	0,  0,										// min, max tracks
	11, 0, pParameters,							// num globalpars, num trackpars, *pars
	0,     NULL,									// num attribs, *attribs
	"Ninereeds Broadcast", "Tx", "Steve Horne",	// name, short name, author
	NULL										// command menu
};

class mi : public CMachineInterface
{
public:
	mi ();
	virtual ~mi();

	virtual void Tick();

public:
	//  Do the following all need to be pointers?
	
	gvals				gval;

	byte                f_Channel;
	c_Broadcast_Params  f_Data;
};

DLL_EXPORTS

mi::mi()
{
	GlobalVals = &gval;
	TrackVals  = NULL;
	AttrVals   = NULL;

	f_Channel = 1;
	f_Data.p_Command = 0;
}

mi::~mi()
{
}

byte g_Channel_Mask [8] = {0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80};

void mi::Tick()
{
	if (gval.p_Channel != 0x00)  {  f_Channel = gval.p_Channel;  }

	if (gval.p_Command != 0)
	{
		f_Data.p_Command = gval.p_Command;

    if (gval.p_Time != 0xFFFF)
    {
      f_Data.p_Time = gval.p_Time;
    }
    else
    {
      f_Data.p_Time = 0;
    }

  	f_Data.p_Byte_Param1 = gval.p_Byte_Param1;
	  f_Data.p_Byte_Param2 = gval.p_Byte_Param2;
	  f_Data.p_Byte_Param3 = gval.p_Byte_Param3;
	  f_Data.p_Byte_Param4 = gval.p_Byte_Param4;

	  f_Data.p_Word_Param1 = gval.p_Word_Param1;
	  f_Data.p_Word_Param2 = gval.p_Word_Param2;
	  f_Data.p_Word_Param3 = gval.p_Word_Param3;
	  f_Data.p_Word_Param4 = gval.p_Word_Param4;

    for (int i = 0; i < 8; i++)
    {
      if ((f_Channel & g_Channel_Mask [i]) != 0)
      {
        NR_Send_Command (i, &f_Data);
      }
    }
	}
}
